/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.shynieke.statues.client.model.PlayerStatueModel;
import com.shynieke.statues.entity.PlayerStatue;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class PlayerStatueRenderer
extends LivingEntityRenderer<PlayerStatue, PlayerStatueModel> {
    private final PlayerStatueModel playerModel;
    private final PlayerStatueModel slimPlayerModel;
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.m_118626_();

    public PlayerStatueRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public PlayerStatueRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerStatueModel(context.m_174023_(ModelLayers.f_171162_), slim), 0.0f);
        this.playerModel = new PlayerStatueModel(context.m_174023_(ModelLayers.f_171162_), false);
        this.slimPlayerModel = new PlayerStatueModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_))));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(PlayerStatue playerStatue) {
        return playerStatue.getGameProfile().map(this::getSkin).orElse(defaultTexture);
    }

    private ResourceLocation getSkin(GameProfile gameProfile) {
        if (!gameProfile.isComplete()) {
            return defaultTexture;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        SkinManager skinManager = minecraft.m_91109_();
        Map loadSkinFromCache = skinManager.m_118815_(gameProfile);
        if (loadSkinFromCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.m_118825_((MinecraftProfileTexture)loadSkinFromCache.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.m_118627_((UUID)gameProfile.getId());
    }

    public void render(PlayerStatue playerStatue, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        if (playerStatue.isSlim() && this.playerModel != this.slimPlayerModel) {
            this.f_115290_ = this.slimPlayerModel;
        }
        poseStack.m_85837_(0.0, (double)playerStatue.getYOffsetData(), 0.0);
        super.m_7392_((LivingEntity)playerStatue, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    protected boolean shouldShowName(PlayerStatue playerStatue) {
        return playerStatue.m_20151_();
    }

    protected void setupRotations(PlayerStatue playerStatue, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        float f = (float)(playerStatue.f_19853_.m_46467_() - playerStatue.punchCooldown) + partialTicks;
        if (f < 5.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14031_((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected void scale(PlayerStatue playerStatue, PoseStack poseStack, float partialTickTime) {
        float f = 0.9375f;
        poseStack.m_85841_(f, f, f);
    }
}

